package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{InAppStreamName, Id}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputDescription(
    inputId: Option[Id] = None,
    namePrefix: Option[InAppStreamName] = None,
    inAppStreamNames: Option[Iterable[InAppStreamName]] = None,
    inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
    ] = None,
    kinesisStreamsInputDescription: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription
    ] = None,
    kinesisFirehoseInputDescription: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
    ] = None,
    inputSchema: Option[zio.aws.kinesisanalyticsv2.model.SourceSchema] = None,
    inputParallelism: Option[
      zio.aws.kinesisanalyticsv2.model.InputParallelism
    ] = None,
    inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription = {
    import InputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription
      .builder()
      .optionallyWith(inputId.map(value => Id.unwrap(value): java.lang.String))(
        _.inputId
      )
      .optionallyWith(
        namePrefix.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.namePrefix)
      .optionallyWith(
        inAppStreamNames.map(value =>
          value.map { item =>
            InAppStreamName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inAppStreamNames)
      .optionallyWith(
        inputProcessingConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.inputProcessingConfigurationDescription)
      .optionallyWith(
        kinesisStreamsInputDescription.map(value => value.buildAwsValue())
      )(_.kinesisStreamsInputDescription)
      .optionallyWith(
        kinesisFirehoseInputDescription.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseInputDescription)
      .optionallyWith(inputSchema.map(value => value.buildAwsValue()))(
        _.inputSchema
      )
      .optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(
        _.inputParallelism
      )
      .optionallyWith(
        inputStartingPositionConfiguration.map(value => value.buildAwsValue())
      )(_.inputStartingPositionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputDescription.wrap(buildAwsValue())
}
object InputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.InputDescription =
      zio.aws.kinesisanalyticsv2.model.InputDescription(
        inputId.map(value => value),
        namePrefix.map(value => value),
        inAppStreamNames.map(value => value),
        inputProcessingConfigurationDescription.map(value => value.asEditable),
        kinesisStreamsInputDescription.map(value => value.asEditable),
        kinesisFirehoseInputDescription.map(value => value.asEditable),
        inputSchema.map(value => value.asEditable),
        inputParallelism.map(value => value.asEditable),
        inputStartingPositionConfiguration.map(value => value.asEditable)
      )
    def inputId: Option[Id]
    def namePrefix: Option[InAppStreamName]
    def inAppStreamNames: Option[List[InAppStreamName]]
    def inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ]
    def kinesisStreamsInputDescription: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription.ReadOnly
    ]
    def kinesisFirehoseInputDescription: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription.ReadOnly
    ]
    def inputSchema
        : Option[zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly]
    def inputParallelism
        : Option[zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly]
    def inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ]
    def getInputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("inputId", inputId)
    def getNamePrefix: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("namePrefix", namePrefix)
    def getInAppStreamNames: ZIO[Any, AwsError, List[InAppStreamName]] =
      AwsError.unwrapOptionField("inAppStreamNames", inAppStreamNames)
    def getInputProcessingConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfigurationDescription",
      inputProcessingConfigurationDescription
    )
    def getKinesisStreamsInputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsInputDescription",
      kinesisStreamsInputDescription
    )
    def getKinesisFirehoseInputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseInputDescription",
      kinesisFirehoseInputDescription
    )
    def getInputSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly
    ] = AwsError.unwrapOptionField("inputSchema", inputSchema)
    def getInputParallelism: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly
    ] = AwsError.unwrapOptionField("inputParallelism", inputParallelism)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputStartingPositionConfiguration",
      inputStartingPositionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription
  ) extends zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly {
    override val inputId: Option[Id] = scala
      .Option(impl.inputId())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.Id(value))
    override val namePrefix: Option[InAppStreamName] = scala
      .Option(impl.namePrefix())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.InAppStreamName(value)
      )
    override val inAppStreamNames: Option[List[InAppStreamName]] = scala
      .Option(impl.inAppStreamNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.primitives.InAppStreamName(item)
        }.toList
      )
    override val inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
          .wrap(value)
      )
    override val kinesisStreamsInputDescription: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamsInputDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription
          .wrap(value)
      )
    override val kinesisFirehoseInputDescription: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseInputDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputDescription
          .wrap(value)
      )
    override val inputSchema
        : Option[zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly] = scala
      .Option(impl.inputSchema())
      .map(value => zio.aws.kinesisanalyticsv2.model.SourceSchema.wrap(value))
    override val inputParallelism
        : Option[zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly] =
      scala
        .Option(impl.inputParallelism())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.InputParallelism.wrap(value)
        )
    override val inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputStartingPositionConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription
  ): zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly = new Wrapper(
    impl
  )
}
