package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FlinkApplicationConfiguration(
    checkpointConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration
    ] = None,
    monitoringConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration
    ] = None,
    parallelismConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration = {
    import FlinkApplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration
      .builder()
      .optionallyWith(
        checkpointConfiguration.map(value => value.buildAwsValue())
      )(_.checkpointConfiguration)
      .optionallyWith(
        monitoringConfiguration.map(value => value.buildAwsValue())
      )(_.monitoringConfiguration)
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration
      .wrap(buildAwsValue())
}
object FlinkApplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration =
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration(
        checkpointConfiguration.map(value => value.asEditable),
        monitoringConfiguration.map(value => value.asEditable),
        parallelismConfiguration.map(value => value.asEditable)
      )
    def checkpointConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.ReadOnly
    ]
    def monitoringConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.ReadOnly
    ]
    def parallelismConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.ReadOnly
    ]
    def getCheckpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "checkpointConfiguration",
      checkpointConfiguration
    )
    def getMonitoringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfiguration",
      monitoringConfiguration
    )
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration.ReadOnly {
    override val checkpointConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.ReadOnly
    ] = scala
      .Option(impl.checkpointConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CheckpointConfiguration.wrap(value)
      )
    override val monitoringConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.ReadOnly
    ] = scala
      .Option(impl.monitoringConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.wrap(value)
      )
    override val parallelismConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.ReadOnly
    ] = scala
      .Option(impl.parallelismConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfiguration
  ): zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
