package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  SnapshotName,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationSnapshotRequest(
    applicationName: ApplicationName,
    snapshotName: SnapshotName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest = {
    import DescribeApplicationSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .snapshotName(SnapshotName.unwrap(snapshotName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest =
      zio.aws.kinesisanalyticsv2.model
        .DescribeApplicationSnapshotRequest(applicationName, snapshotName)
    def applicationName: ApplicationName
    def snapshotName: SnapshotName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getSnapshotName: ZIO[Any, Nothing, SnapshotName] =
      ZIO.succeed(snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val snapshotName: SnapshotName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .SnapshotName(impl.snapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest
  ): zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
