package zio.aws.kinesisanalyticsv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  NextToken,
  ListSnapshotsInputLimit,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListApplicationSnapshotsRequest(
    applicationName: ApplicationName,
    limit: Option[ListSnapshotsInputLimit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest = {
    import ListApplicationSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        limit.map(value => ListSnapshotsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
      .wrap(buildAwsValue())
}
object ListApplicationSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest =
      zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest(
        applicationName,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: ApplicationName
    def limit: Option[ListSnapshotsInputLimit]
    def nextToken: Option[NextToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getLimit: ZIO[Any, AwsError, ListSnapshotsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val limit: Option[ListSnapshotsInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .ListSnapshotsInputLimit(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
