package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteApplicationReferenceDataSourceResponse(
    applicationARN: Option[ResourceARN] = None,
    applicationVersionId: Option[ApplicationVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse = {
    import DeleteApplicationReferenceDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse
      .wrap(buildAwsValue())
}
object DeleteApplicationReferenceDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse =
      zio.aws.kinesisanalyticsv2.model
        .DeleteApplicationReferenceDataSourceResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value)
        )
    def applicationARN: Option[ResourceARN]
    def applicationVersionId: Option[ApplicationVersionId]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly {
    override val applicationARN: Option[ResourceARN] = scala
      .Option(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Option[ApplicationVersionId] = scala
      .Option(impl.applicationVersionId())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly =
    new Wrapper(impl)
}
