package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomArtifactConfigurationDescription(
    artifactType: Option[zio.aws.kinesisanalyticsv2.model.ArtifactType] = None,
    s3ContentLocationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation
    ] = None,
    mavenReferenceDescription: Option[
      zio.aws.kinesisanalyticsv2.model.MavenReference
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription = {
    import CustomArtifactConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
      .builder()
      .optionallyWith(artifactType.map(value => value.unwrap))(_.artifactType)
      .optionallyWith(
        s3ContentLocationDescription.map(value => value.buildAwsValue())
      )(_.s3ContentLocationDescription)
      .optionallyWith(
        mavenReferenceDescription.map(value => value.buildAwsValue())
      )(_.mavenReferenceDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
      .wrap(buildAwsValue())
}
object CustomArtifactConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription(
        artifactType.map(value => value),
        s3ContentLocationDescription.map(value => value.asEditable),
        mavenReferenceDescription.map(value => value.asEditable)
      )
    def artifactType: Option[zio.aws.kinesisanalyticsv2.model.ArtifactType]
    def s3ContentLocationDescription
        : Option[zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly]
    def mavenReferenceDescription
        : Option[zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly]
    def getArtifactType
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.ArtifactType] =
      AwsError.unwrapOptionField("artifactType", artifactType)
    def getS3ContentLocationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3ContentLocationDescription",
      s3ContentLocationDescription
    )
    def getMavenReferenceDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mavenReferenceDescription",
      mavenReferenceDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly {
    override val artifactType
        : Option[zio.aws.kinesisanalyticsv2.model.ArtifactType] = scala
      .Option(impl.artifactType())
      .map(value => zio.aws.kinesisanalyticsv2.model.ArtifactType.wrap(value))
    override val s3ContentLocationDescription
        : Option[zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly] =
      scala
        .Option(impl.s3ContentLocationDescription())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.S3ContentLocation.wrap(value)
        )
    override val mavenReferenceDescription
        : Option[zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly] =
      scala
        .Option(impl.mavenReferenceDescription())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.MavenReference.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
