package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    applicationName: ApplicationName,
    applicationARN: ResourceARN,
    applicationStatus: zio.aws.kinesisanalyticsv2.model.ApplicationStatus,
    applicationVersionId: ApplicationVersionId,
    runtimeEnvironment: zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment,
    applicationMode: Option[zio.aws.kinesisanalyticsv2.model.ApplicationMode] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSummary
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .applicationARN(ResourceARN.unwrap(applicationARN): java.lang.String)
      .applicationStatus(applicationStatus.unwrap)
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .runtimeEnvironment(runtimeEnvironment.unwrap)
      .optionallyWith(applicationMode.map(value => value.unwrap))(
        _.applicationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ApplicationSummary =
      zio.aws.kinesisanalyticsv2.model.ApplicationSummary(
        applicationName,
        applicationARN,
        applicationStatus,
        applicationVersionId,
        runtimeEnvironment,
        applicationMode.map(value => value)
      )
    def applicationName: ApplicationName
    def applicationARN: ResourceARN
    def applicationStatus: zio.aws.kinesisanalyticsv2.model.ApplicationStatus
    def applicationVersionId: ApplicationVersionId
    def runtimeEnvironment: zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
    def applicationMode
        : Option[zio.aws.kinesisanalyticsv2.model.ApplicationMode]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(applicationARN)
    def getApplicationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationStatus
    ] = ZIO.succeed(applicationStatus)
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
    def getRuntimeEnvironment: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
    ] = ZIO.succeed(runtimeEnvironment)
    def getApplicationMode
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.ApplicationMode] =
      AwsError.unwrapOptionField("applicationMode", applicationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSummary
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.applicationARN())
    override val applicationStatus
        : zio.aws.kinesisanalyticsv2.model.ApplicationStatus =
      zio.aws.kinesisanalyticsv2.model.ApplicationStatus
        .wrap(impl.applicationStatus())
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
    override val runtimeEnvironment
        : zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment =
      zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
        .wrap(impl.runtimeEnvironment())
    override val applicationMode
        : Option[zio.aws.kinesisanalyticsv2.model.ApplicationMode] = scala
      .Option(impl.applicationMode())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationMode.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSummary
  ): zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly = new Wrapper(
    impl
  )
}
