package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationCodeConfigurationUpdate(
    codeContentTypeUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CodeContentType
    ] = None,
    codeContentUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CodeContentUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate = {
    import ApplicationCodeConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
      .builder()
      .optionallyWith(codeContentTypeUpdate.map(value => value.unwrap))(
        _.codeContentTypeUpdate
      )
      .optionallyWith(codeContentUpdate.map(value => value.buildAwsValue()))(
        _.codeContentUpdate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
      .wrap(buildAwsValue())
}
object ApplicationCodeConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate(
        codeContentTypeUpdate.map(value => value),
        codeContentUpdate.map(value => value.asEditable)
      )
    def codeContentTypeUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.CodeContentType]
    def codeContentUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly]
    def getCodeContentTypeUpdate
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.CodeContentType] =
      AwsError.unwrapOptionField("codeContentTypeUpdate", codeContentTypeUpdate)
    def getCodeContentUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("codeContentUpdate", codeContentUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly {
    override val codeContentTypeUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.CodeContentType] = scala
      .Option(impl.codeContentTypeUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CodeContentType.wrap(value)
      )
    override val codeContentUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly] =
      scala
        .Option(impl.codeContentUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
