package zio.aws.kinesisanalyticsv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  BooleanObject,
  ParallelismPerKPU,
  Parallelism
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ParallelismConfiguration(
    configurationType: zio.aws.kinesisanalyticsv2.model.ConfigurationType,
    parallelism: Option[Parallelism] = None,
    parallelismPerKPU: Option[ParallelismPerKPU] = None,
    autoScalingEnabled: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfiguration = {
    import ParallelismConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfiguration
      .builder()
      .configurationType(configurationType.unwrap)
      .optionallyWith(
        parallelism.map(value => Parallelism.unwrap(value): Integer)
      )(_.parallelism)
      .optionallyWith(
        parallelismPerKPU.map(value => ParallelismPerKPU.unwrap(value): Integer)
      )(_.parallelismPerKPU)
      .optionallyWith(
        autoScalingEnabled.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.autoScalingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration
      .wrap(buildAwsValue())
}
object ParallelismConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration =
      zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration(
        configurationType,
        parallelism.map(value => value),
        parallelismPerKPU.map(value => value),
        autoScalingEnabled.map(value => value)
      )
    def configurationType: zio.aws.kinesisanalyticsv2.model.ConfigurationType
    def parallelism: Option[Parallelism]
    def parallelismPerKPU: Option[ParallelismPerKPU]
    def autoScalingEnabled: Option[BooleanObject]
    def getConfigurationType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = ZIO.succeed(configurationType)
    def getParallelism: ZIO[Any, AwsError, Parallelism] =
      AwsError.unwrapOptionField("parallelism", parallelism)
    def getParallelismPerKPU: ZIO[Any, AwsError, ParallelismPerKPU] =
      AwsError.unwrapOptionField("parallelismPerKPU", parallelismPerKPU)
    def getAutoScalingEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingEnabled", autoScalingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.ReadOnly {
    override val configurationType
        : zio.aws.kinesisanalyticsv2.model.ConfigurationType =
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
        .wrap(impl.configurationType())
    override val parallelism: Option[Parallelism] = scala
      .Option(impl.parallelism())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.Parallelism(value)
      )
    override val parallelismPerKPU: Option[ParallelismPerKPU] = scala
      .Option(impl.parallelismPerKPU())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ParallelismPerKPU(value)
      )
    override val autoScalingEnabled: Option[BooleanObject] = scala
      .Option(impl.autoScalingEnabled())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ParallelismConfiguration.ReadOnly =
    new Wrapper(impl)
}
