package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MonitoringConfigurationUpdate(
    configurationTypeUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = None,
    metricsLevelUpdate: Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel] =
      None,
    logLevelUpdate: Option[zio.aws.kinesisanalyticsv2.model.LogLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate = {
    import MonitoringConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
      .builder()
      .optionallyWith(configurationTypeUpdate.map(value => value.unwrap))(
        _.configurationTypeUpdate
      )
      .optionallyWith(metricsLevelUpdate.map(value => value.unwrap))(
        _.metricsLevelUpdate
      )
      .optionallyWith(logLevelUpdate.map(value => value.unwrap))(
        _.logLevelUpdate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
      .wrap(buildAwsValue())
}
object MonitoringConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate(
        configurationTypeUpdate.map(value => value),
        metricsLevelUpdate.map(value => value),
        logLevelUpdate.map(value => value)
      )
    def configurationTypeUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def metricsLevelUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel]
    def logLevelUpdate: Option[zio.aws.kinesisanalyticsv2.model.LogLevel]
    def getConfigurationTypeUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField(
      "configurationTypeUpdate",
      configurationTypeUpdate
    )
    def getMetricsLevelUpdate
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.MetricsLevel] =
      AwsError.unwrapOptionField("metricsLevelUpdate", metricsLevelUpdate)
    def getLogLevelUpdate
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.LogLevel] =
      AwsError.unwrapOptionField("logLevelUpdate", logLevelUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly {
    override val configurationTypeUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType] = scala
      .Option(impl.configurationTypeUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
      )
    override val metricsLevelUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel] = scala
      .Option(impl.metricsLevelUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.MetricsLevel.wrap(value))
    override val logLevelUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.LogLevel] = scala
      .Option(impl.logLevelUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
