package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationCodeConfigurationDescription(
    codeContentType: zio.aws.kinesisanalyticsv2.model.CodeContentType,
    codeContentDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CodeContentDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription = {
    import ApplicationCodeConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
      .builder()
      .codeContentType(codeContentType.unwrap)
      .optionallyWith(
        codeContentDescription.map(value => value.buildAwsValue())
      )(_.codeContentDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
      .wrap(buildAwsValue())
}
object ApplicationCodeConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription(
        codeContentType,
        codeContentDescription.map(value => value.asEditable)
      )
    def codeContentType: zio.aws.kinesisanalyticsv2.model.CodeContentType
    def codeContentDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CodeContentDescription.ReadOnly
    ]
    def getCodeContentType
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.CodeContentType] =
      ZIO.succeed(codeContentType)
    def getCodeContentDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CodeContentDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "codeContentDescription",
      codeContentDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription.ReadOnly {
    override val codeContentType
        : zio.aws.kinesisanalyticsv2.model.CodeContentType =
      zio.aws.kinesisanalyticsv2.model.CodeContentType
        .wrap(impl.codeContentType())
    override val codeContentDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CodeContentDescription.ReadOnly
    ] = scala
      .Option(impl.codeContentDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CodeContentDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
