package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Timestamp,
  ApplicationVersionId,
  SnapshotName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SnapshotDetails(
    snapshotName: SnapshotName,
    snapshotStatus: zio.aws.kinesisanalyticsv2.model.SnapshotStatus,
    applicationVersionId: ApplicationVersionId,
    snapshotCreationTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails = {
    import SnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails
      .builder()
      .snapshotName(SnapshotName.unwrap(snapshotName): java.lang.String)
      .snapshotStatus(snapshotStatus.unwrap)
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .optionallyWith(
        snapshotCreationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.snapshotCreationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.SnapshotDetails.wrap(buildAwsValue())
}
object SnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.SnapshotDetails =
      zio.aws.kinesisanalyticsv2.model.SnapshotDetails(
        snapshotName,
        snapshotStatus,
        applicationVersionId,
        snapshotCreationTimestamp.map(value => value)
      )
    def snapshotName: SnapshotName
    def snapshotStatus: zio.aws.kinesisanalyticsv2.model.SnapshotStatus
    def applicationVersionId: ApplicationVersionId
    def snapshotCreationTimestamp: Option[Timestamp]
    def getSnapshotName: ZIO[Any, Nothing, SnapshotName] =
      ZIO.succeed(snapshotName)
    def getSnapshotStatus
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.SnapshotStatus] =
      ZIO.succeed(snapshotStatus)
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
    def getSnapshotCreationTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("snapshotCreationTimestamp", snapshotCreationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails
  ) extends zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly {
    override val snapshotName: SnapshotName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .SnapshotName(impl.snapshotName())
    override val snapshotStatus
        : zio.aws.kinesisanalyticsv2.model.SnapshotStatus =
      zio.aws.kinesisanalyticsv2.model.SnapshotStatus
        .wrap(impl.snapshotStatus())
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
    override val snapshotCreationTimestamp: Option[Timestamp] = scala
      .Option(impl.snapshotCreationTimestamp())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails
  ): zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly = new Wrapper(
    impl
  )
}
