package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{BasePath, BucketARN}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3ContentBaseLocationUpdate(
    bucketARNUpdate: Option[BucketARN] = None,
    basePathUpdate: Option[BasePath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate = {
    import S3ContentBaseLocationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate
      .builder()
      .optionallyWith(
        bucketARNUpdate.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARNUpdate)
      .optionallyWith(
        basePathUpdate.map(value => BasePath.unwrap(value): java.lang.String)
      )(_.basePathUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate
      .wrap(buildAwsValue())
}
object S3ContentBaseLocationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate =
      zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate(
        bucketARNUpdate.map(value => value),
        basePathUpdate.map(value => value)
      )
    def bucketARNUpdate: Option[BucketARN]
    def basePathUpdate: Option[BasePath]
    def getBucketARNUpdate: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARNUpdate", bucketARNUpdate)
    def getBasePathUpdate: ZIO[Any, AwsError, BasePath] =
      AwsError.unwrapOptionField("basePathUpdate", basePathUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.ReadOnly {
    override val bucketARNUpdate: Option[BucketARN] = scala
      .Option(impl.bucketARNUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(value)
      )
    override val basePathUpdate: Option[BasePath] = scala
      .Option(impl.basePathUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.BasePath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate
  ): zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocationUpdate.ReadOnly =
    new Wrapper(impl)
}
