package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentProperties(
    propertyGroups: Iterable[zio.aws.kinesisanalyticsv2.model.PropertyGroup]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentProperties = {
    import EnvironmentProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentProperties
      .builder()
      .propertyGroups(propertyGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.wrap(buildAwsValue())
}
object EnvironmentProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.EnvironmentProperties =
      zio.aws.kinesisanalyticsv2.model
        .EnvironmentProperties(propertyGroups.map { item =>
          item.asEditable
        })
    def propertyGroups
        : List[zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly]
    def getPropertyGroups: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly
    ]] = ZIO.succeed(propertyGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentProperties
  ) extends zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.ReadOnly {
    override val propertyGroups
        : List[zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly] = impl
      .propertyGroups()
      .asScala
      .map { item =>
        zio.aws.kinesisanalyticsv2.model.PropertyGroup.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentProperties
  ): zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.ReadOnly =
    new Wrapper(impl)
}
