package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  SnapshotName,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateApplicationSnapshotRequest(
    applicationName: ApplicationName,
    snapshotName: SnapshotName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest = {
    import CreateApplicationSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .snapshotName(SnapshotName.unwrap(snapshotName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateApplicationSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest =
      zio.aws.kinesisanalyticsv2.model
        .CreateApplicationSnapshotRequest(applicationName, snapshotName)
    def applicationName: ApplicationName
    def snapshotName: SnapshotName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getSnapshotName: ZIO[Any, Nothing, SnapshotName] =
      ZIO.succeed(snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest
  ) extends zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val snapshotName: SnapshotName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .SnapshotName(impl.snapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest
  ): zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
