package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  MinPauseBetweenCheckpoints,
  CheckpointInterval,
  BooleanObject
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CheckpointConfigurationUpdate(
    configurationTypeUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = None,
    checkpointingEnabledUpdate: Option[BooleanObject] = None,
    checkpointIntervalUpdate: Option[CheckpointInterval] = None,
    minPauseBetweenCheckpointsUpdate: Option[MinPauseBetweenCheckpoints] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate = {
    import CheckpointConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
      .builder()
      .optionallyWith(configurationTypeUpdate.map(value => value.unwrap))(
        _.configurationTypeUpdate
      )
      .optionallyWith(
        checkpointingEnabledUpdate.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.checkpointingEnabledUpdate)
      .optionallyWith(
        checkpointIntervalUpdate.map(value =>
          CheckpointInterval.unwrap(value): java.lang.Long
        )
      )(_.checkpointIntervalUpdate)
      .optionallyWith(
        minPauseBetweenCheckpointsUpdate.map(value =>
          MinPauseBetweenCheckpoints.unwrap(value): java.lang.Long
        )
      )(_.minPauseBetweenCheckpointsUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
      .wrap(buildAwsValue())
}
object CheckpointConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate(
        configurationTypeUpdate.map(value => value),
        checkpointingEnabledUpdate.map(value => value),
        checkpointIntervalUpdate.map(value => value),
        minPauseBetweenCheckpointsUpdate.map(value => value)
      )
    def configurationTypeUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def checkpointingEnabledUpdate: Option[BooleanObject]
    def checkpointIntervalUpdate: Option[CheckpointInterval]
    def minPauseBetweenCheckpointsUpdate: Option[MinPauseBetweenCheckpoints]
    def getConfigurationTypeUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField(
      "configurationTypeUpdate",
      configurationTypeUpdate
    )
    def getCheckpointingEnabledUpdate: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "checkpointingEnabledUpdate",
        checkpointingEnabledUpdate
      )
    def getCheckpointIntervalUpdate: ZIO[Any, AwsError, CheckpointInterval] =
      AwsError.unwrapOptionField(
        "checkpointIntervalUpdate",
        checkpointIntervalUpdate
      )
    def getMinPauseBetweenCheckpointsUpdate
        : ZIO[Any, AwsError, MinPauseBetweenCheckpoints] =
      AwsError.unwrapOptionField(
        "minPauseBetweenCheckpointsUpdate",
        minPauseBetweenCheckpointsUpdate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly {
    override val configurationTypeUpdate
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType] = scala
      .Option(impl.configurationTypeUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
      )
    override val checkpointingEnabledUpdate: Option[BooleanObject] = scala
      .Option(impl.checkpointingEnabledUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject(value)
      )
    override val checkpointIntervalUpdate: Option[CheckpointInterval] = scala
      .Option(impl.checkpointIntervalUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.CheckpointInterval(value)
      )
    override val minPauseBetweenCheckpointsUpdate
        : Option[MinPauseBetweenCheckpoints] = scala
      .Option(impl.minPauseBetweenCheckpointsUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .MinPauseBetweenCheckpoints(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
