package zio.aws.kinesisanalyticsv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  BooleanObject,
  ParallelismPerKPU,
  Parallelism
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ParallelismConfigurationDescription(
    configurationType: Option[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = None,
    parallelism: Option[Parallelism] = None,
    parallelismPerKPU: Option[ParallelismPerKPU] = None,
    currentParallelism: Option[Parallelism] = None,
    autoScalingEnabled: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription = {
    import ParallelismConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
      .builder()
      .optionallyWith(configurationType.map(value => value.unwrap))(
        _.configurationType
      )
      .optionallyWith(
        parallelism.map(value => Parallelism.unwrap(value): Integer)
      )(_.parallelism)
      .optionallyWith(
        parallelismPerKPU.map(value => ParallelismPerKPU.unwrap(value): Integer)
      )(_.parallelismPerKPU)
      .optionallyWith(
        currentParallelism.map(value => Parallelism.unwrap(value): Integer)
      )(_.currentParallelism)
      .optionallyWith(
        autoScalingEnabled.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.autoScalingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription
      .wrap(buildAwsValue())
}
object ParallelismConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription(
        configurationType.map(value => value),
        parallelism.map(value => value),
        parallelismPerKPU.map(value => value),
        currentParallelism.map(value => value),
        autoScalingEnabled.map(value => value)
      )
    def configurationType
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def parallelism: Option[Parallelism]
    def parallelismPerKPU: Option[ParallelismPerKPU]
    def currentParallelism: Option[Parallelism]
    def autoScalingEnabled: Option[BooleanObject]
    def getConfigurationType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField("configurationType", configurationType)
    def getParallelism: ZIO[Any, AwsError, Parallelism] =
      AwsError.unwrapOptionField("parallelism", parallelism)
    def getParallelismPerKPU: ZIO[Any, AwsError, ParallelismPerKPU] =
      AwsError.unwrapOptionField("parallelismPerKPU", parallelismPerKPU)
    def getCurrentParallelism: ZIO[Any, AwsError, Parallelism] =
      AwsError.unwrapOptionField("currentParallelism", currentParallelism)
    def getAutoScalingEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingEnabled", autoScalingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly {
    override val configurationType
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType] = scala
      .Option(impl.configurationType())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
      )
    override val parallelism: Option[Parallelism] = scala
      .Option(impl.parallelism())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.Parallelism(value)
      )
    override val parallelismPerKPU: Option[ParallelismPerKPU] = scala
      .Option(impl.parallelismPerKPU())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ParallelismPerKPU(value)
      )
    override val currentParallelism: Option[Parallelism] = scala
      .Option(impl.currentParallelism())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.Parallelism(value)
      )
    override val autoScalingEnabled: Option[BooleanObject] = scala
      .Option(impl.autoScalingEnabled())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
