package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters._
sealed trait LogLevel {
  def unwrap: software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel
  ): zio.aws.kinesisanalyticsv2.model.LogLevel = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.WARN =>
      val r = WARN
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.DEBUG =>
      val r = DEBUG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object INFO extends zio.aws.kinesisanalyticsv2.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.INFO
  }
  case object WARN extends zio.aws.kinesisanalyticsv2.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.WARN
  }
  case object ERROR extends zio.aws.kinesisanalyticsv2.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.ERROR
  }
  case object DEBUG extends zio.aws.kinesisanalyticsv2.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel.DEBUG
  }
}
