package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteApplicationVpcConfigurationResponse(
    applicationARN: Option[ResourceARN] = None,
    applicationVersionId: Option[ApplicationVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse = {
    import DeleteApplicationVpcConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse
      .wrap(buildAwsValue())
}
object DeleteApplicationVpcConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse =
      zio.aws.kinesisanalyticsv2.model
        .DeleteApplicationVpcConfigurationResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value)
        )
    def applicationARN: Option[ResourceARN]
    def applicationVersionId: Option[ApplicationVersionId]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly {
    override val applicationARN: Option[ResourceARN] = scala
      .Option(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Option[ApplicationVersionId] = scala
      .Option(impl.applicationVersionId())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
