package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddApplicationInputResponse(
    applicationARN: Option[ResourceARN] = None,
    applicationVersionId: Option[ApplicationVersionId] = None,
    inputDescriptions: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.InputDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse = {
    import AddApplicationInputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        inputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse
      .wrap(buildAwsValue())
}
object AddApplicationInputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse =
      zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse(
        applicationARN.map(value => value),
        applicationVersionId.map(value => value),
        inputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationARN: Option[ResourceARN]
    def applicationVersionId: Option[ApplicationVersionId]
    def inputDescriptions: Option[
      List[zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly]
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getInputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDescriptions", inputDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly {
    override val applicationARN: Option[ResourceARN] = scala
      .Option(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Option[ApplicationVersionId] = scala
      .Option(impl.applicationVersionId())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
    override val inputDescriptions: Option[
      List[zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly]
    ] = scala
      .Option(impl.inputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.InputDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly =
    new Wrapper(impl)
}
