package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, LogStreamARN, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLoggingOptionDescription(
    cloudWatchLoggingOptionId: Optional[Id] = Optional.Absent,
    logStreamARN: LogStreamARN,
    roleARN: RoleARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription = {
    import CloudWatchLoggingOptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription
      .builder()
      .optionallyWith(
        cloudWatchLoggingOptionId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLoggingOptionId)
      .logStreamARN(LogStreamARN.unwrap(logStreamARN): java.lang.String)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription
      .wrap(buildAwsValue())
}
object CloudWatchLoggingOptionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription =
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription(
        cloudWatchLoggingOptionId.map(value => value),
        logStreamARN,
        roleARN
      )
    def cloudWatchLoggingOptionId: Optional[Id]
    def logStreamARN: LogStreamARN
    def roleARN: RoleARN
    def getCloudWatchLoggingOptionId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("cloudWatchLoggingOptionId", cloudWatchLoggingOptionId)
    def getLogStreamARN: ZIO[Any, Nothing, LogStreamARN] =
      ZIO.succeed(logStreamARN)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription
  ) extends zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly {
    override val cloudWatchLoggingOptionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionId())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Id(value))
    override val logStreamARN: LogStreamARN =
      zio.aws.kinesisanalytics.model.primitives
        .LogStreamARN(impl.logStreamARN())
    override val roleARN: RoleARN =
      zio.aws.kinesisanalytics.model.primitives.RoleARN(impl.roleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription
  ): zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly =
    new Wrapper(impl)
}
