package zio.aws.kinesisanalytics.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationStatus {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus
}
object ApplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus
  ): zio.aws.kinesisanalytics.model.ApplicationStatus = value match {
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DELETING
      extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.DELETING
  }
  case object STARTING
      extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STARTING
  }
  case object STOPPING
      extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STOPPING
  }
  case object READY extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.READY
  }
  case object RUNNING extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.RUNNING
  }
  case object UPDATING
      extends zio.aws.kinesisanalytics.model.ApplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus =
      software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UPDATING
  }
}
