package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    applicationUpdate: zio.aws.kinesisanalytics.model.ApplicationUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .applicationUpdate(applicationUpdate.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.UpdateApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.UpdateApplicationRequest =
      zio.aws.kinesisanalytics.model.UpdateApplicationRequest(
        applicationName,
        currentApplicationVersionId,
        applicationUpdate.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def applicationUpdate
        : zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getApplicationUpdate: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly
    ] = ZIO.succeed(applicationUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest
  ) extends zio.aws.kinesisanalytics.model.UpdateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val applicationUpdate
        : zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly =
      zio.aws.kinesisanalytics.model.ApplicationUpdate
        .wrap(impl.applicationUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest
  ): zio.aws.kinesisanalytics.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
