package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.ApplicationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartApplicationRequest(
    applicationName: ApplicationName,
    inputConfigurations: Iterable[
      zio.aws.kinesisanalytics.model.InputConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest = {
    import StartApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .inputConfigurations(inputConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.StartApplicationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.StartApplicationRequest.wrap(buildAwsValue())
}
object StartApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.StartApplicationRequest =
      zio.aws.kinesisanalytics.model.StartApplicationRequest(
        applicationName,
        inputConfigurations.map { item =>
          item.asEditable
        }
      )
    def applicationName: ApplicationName
    def inputConfigurations
        : List[zio.aws.kinesisanalytics.model.InputConfiguration.ReadOnly]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getInputConfigurations: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalytics.model.InputConfiguration.ReadOnly
    ]] = ZIO.succeed(inputConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest
  ) extends zio.aws.kinesisanalytics.model.StartApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val inputConfigurations
        : List[zio.aws.kinesisanalytics.model.InputConfiguration.ReadOnly] =
      impl
        .inputConfigurations()
        .asScala
        .map { item =>
          zio.aws.kinesisanalytics.model.InputConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest
  ): zio.aws.kinesisanalytics.model.StartApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
