package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddApplicationReferenceDataSourceRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    referenceDataSource: zio.aws.kinesisanalytics.model.ReferenceDataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest = {
    import AddApplicationReferenceDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .referenceDataSource(referenceDataSource.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
      .wrap(buildAwsValue())
}
object AddApplicationReferenceDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest =
      zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest(
        applicationName,
        currentApplicationVersionId,
        referenceDataSource.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def referenceDataSource
        : zio.aws.kinesisanalytics.model.ReferenceDataSource.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getReferenceDataSource: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.ReferenceDataSource.ReadOnly
    ] = ZIO.succeed(referenceDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
  ) extends zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val referenceDataSource
        : zio.aws.kinesisanalytics.model.ReferenceDataSource.ReadOnly =
      zio.aws.kinesisanalytics.model.ReferenceDataSource
        .wrap(impl.referenceDataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
  ): zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
