package zio.aws.kinesisanalytics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisanalytics.model.primitives.InputParallelismCount
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InputParallelismUpdate(
    countUpdate: Optional[InputParallelismCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate = {
    import InputParallelismUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate
      .builder()
      .optionallyWith(
        countUpdate.map(value => InputParallelismCount.unwrap(value): Integer)
      )(_.countUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.InputParallelismUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.InputParallelismUpdate.wrap(buildAwsValue())
}
object InputParallelismUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputParallelismUpdate =
      zio.aws.kinesisanalytics.model
        .InputParallelismUpdate(countUpdate.map(value => value))
    def countUpdate: Optional[InputParallelismCount]
    def getCountUpdate: ZIO[Any, AwsError, InputParallelismCount] =
      AwsError.unwrapOptionField("countUpdate", countUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate
  ) extends zio.aws.kinesisanalytics.model.InputParallelismUpdate.ReadOnly {
    override val countUpdate: Optional[InputParallelismCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.InputParallelismCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate
  ): zio.aws.kinesisanalytics.model.InputParallelismUpdate.ReadOnly =
    new Wrapper(impl)
}
