package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApplicationInputProcessingConfigurationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    inputId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest = {
    import DeleteApplicationInputProcessingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .inputId(Id.unwrap(inputId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationInputProcessingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest =
      zio.aws.kinesisanalytics.model
        .DeleteApplicationInputProcessingConfigurationRequest(
          applicationName,
          currentApplicationVersionId,
          inputId
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def inputId: Id
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getInputId: ZIO[Any, Nothing, Id] = ZIO.succeed(inputId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
  ) extends zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val inputId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.inputId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
  ): zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
