package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, FileKey, BucketARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3ReferenceDataSourceDescription(
    bucketARN: BucketARN,
    fileKey: FileKey,
    referenceRoleARN: RoleARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription = {
    import S3ReferenceDataSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .referenceRoleARN(RoleARN.unwrap(referenceRoleARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription
      .wrap(buildAwsValue())
}
object S3ReferenceDataSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription =
      zio.aws.kinesisanalytics.model
        .S3ReferenceDataSourceDescription(bucketARN, fileKey, referenceRoleARN)
    def bucketARN: BucketARN
    def fileKey: FileKey
    def referenceRoleARN: RoleARN
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
    def getReferenceRoleARN: ZIO[Any, Nothing, RoleARN] =
      ZIO.succeed(referenceRoleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription
  ) extends zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalytics.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalytics.model.primitives.FileKey(impl.fileKey())
    override val referenceRoleARN: RoleARN =
      zio.aws.kinesisanalytics.model.primitives.RoleARN(impl.referenceRoleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription
  ): zio.aws.kinesisanalytics.model.S3ReferenceDataSourceDescription.ReadOnly =
    new Wrapper(impl)
}
