package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseInput(
    resourceARN: ResourceARN,
    roleARN: RoleARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput = {
    import KinesisFirehoseInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly =
    zio.aws.kinesisanalytics.model.KinesisFirehoseInput.wrap(buildAwsValue())
}
object KinesisFirehoseInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.KinesisFirehoseInput =
      zio.aws.kinesisanalytics.model.KinesisFirehoseInput(resourceARN, roleARN)
    def resourceARN: ResourceARN
    def roleARN: RoleARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput
  ) extends zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalytics.model.primitives.ResourceARN(impl.resourceARN())
    override val roleARN: RoleARN =
      zio.aws.kinesisanalytics.model.primitives.RoleARN(impl.roleARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInput
  ): zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly = new Wrapper(
    impl
  )
}
