package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, LogStreamARN, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLoggingOptionUpdate(
    cloudWatchLoggingOptionId: Id,
    logStreamARNUpdate: Optional[LogStreamARN] = Optional.Absent,
    roleARNUpdate: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate = {
    import CloudWatchLoggingOptionUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
      .builder()
      .cloudWatchLoggingOptionId(
        Id.unwrap(cloudWatchLoggingOptionId): java.lang.String
      )
      .optionallyWith(
        logStreamARNUpdate.map(value =>
          LogStreamARN.unwrap(value): java.lang.String
        )
      )(_.logStreamARNUpdate)
      .optionallyWith(
        roleARNUpdate.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARNUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
      .wrap(buildAwsValue())
}
object CloudWatchLoggingOptionUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate =
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate(
        cloudWatchLoggingOptionId,
        logStreamARNUpdate.map(value => value),
        roleARNUpdate.map(value => value)
      )
    def cloudWatchLoggingOptionId: Id
    def logStreamARNUpdate: Optional[LogStreamARN]
    def roleARNUpdate: Optional[RoleARN]
    def getCloudWatchLoggingOptionId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(cloudWatchLoggingOptionId)
    def getLogStreamARNUpdate: ZIO[Any, AwsError, LogStreamARN] =
      AwsError.unwrapOptionField("logStreamARNUpdate", logStreamARNUpdate)
    def getRoleARNUpdate: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
  ) extends zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly {
    override val cloudWatchLoggingOptionId: Id =
      zio.aws.kinesisanalytics.model.primitives
        .Id(impl.cloudWatchLoggingOptionId())
    override val logStreamARNUpdate: Optional[LogStreamARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logStreamARNUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.LogStreamARN(value)
        )
    override val roleARNUpdate: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
  ): zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly =
    new Wrapper(impl)
}
