package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.RecordRowPath
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JSONMappingParameters(recordRowPath: RecordRowPath) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters = {
    import JSONMappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters
      .builder()
      .recordRowPath(RecordRowPath.unwrap(recordRowPath): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.JSONMappingParameters.ReadOnly =
    zio.aws.kinesisanalytics.model.JSONMappingParameters.wrap(buildAwsValue())
}
object JSONMappingParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.JSONMappingParameters =
      zio.aws.kinesisanalytics.model.JSONMappingParameters(recordRowPath)
    def recordRowPath: RecordRowPath
    def getRecordRowPath: ZIO[Any, Nothing, RecordRowPath] =
      ZIO.succeed(recordRowPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters
  ) extends zio.aws.kinesisanalytics.model.JSONMappingParameters.ReadOnly {
    override val recordRowPath: RecordRowPath =
      zio.aws.kinesisanalytics.model.primitives
        .RecordRowPath(impl.recordRowPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.JSONMappingParameters
  ): zio.aws.kinesisanalytics.model.JSONMappingParameters.ReadOnly =
    new Wrapper(impl)
}
