package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MappingParameters(
    jsonMappingParameters: Optional[
      zio.aws.kinesisanalytics.model.JSONMappingParameters
    ] = Optional.Absent,
    csvMappingParameters: Optional[
      zio.aws.kinesisanalytics.model.CSVMappingParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters = {
    import MappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters
      .builder()
      .optionallyWith(
        jsonMappingParameters.map(value => value.buildAwsValue())
      )(_.jsonMappingParameters)
      .optionallyWith(csvMappingParameters.map(value => value.buildAwsValue()))(
        _.csvMappingParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.MappingParameters.ReadOnly =
    zio.aws.kinesisanalytics.model.MappingParameters.wrap(buildAwsValue())
}
object MappingParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.MappingParameters =
      zio.aws.kinesisanalytics.model.MappingParameters(
        jsonMappingParameters.map(value => value.asEditable),
        csvMappingParameters.map(value => value.asEditable)
      )
    def jsonMappingParameters: Optional[
      zio.aws.kinesisanalytics.model.JSONMappingParameters.ReadOnly
    ]
    def csvMappingParameters
        : Optional[zio.aws.kinesisanalytics.model.CSVMappingParameters.ReadOnly]
    def getJsonMappingParameters: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.JSONMappingParameters.ReadOnly
    ] =
      AwsError.unwrapOptionField("jsonMappingParameters", jsonMappingParameters)
    def getCsvMappingParameters: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.CSVMappingParameters.ReadOnly
    ] = AwsError.unwrapOptionField("csvMappingParameters", csvMappingParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters
  ) extends zio.aws.kinesisanalytics.model.MappingParameters.ReadOnly {
    override val jsonMappingParameters: Optional[
      zio.aws.kinesisanalytics.model.JSONMappingParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.jsonMappingParameters())
      .map(value =>
        zio.aws.kinesisanalytics.model.JSONMappingParameters.wrap(value)
      )
    override val csvMappingParameters: Optional[
      zio.aws.kinesisanalytics.model.CSVMappingParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.csvMappingParameters())
      .map(value =>
        zio.aws.kinesisanalytics.model.CSVMappingParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters
  ): zio.aws.kinesisanalytics.model.MappingParameters.ReadOnly = new Wrapper(
    impl
  )
}
