package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputStartingPositionConfiguration(
    inputStartingPosition: Optional[
      zio.aws.kinesisanalytics.model.InputStartingPosition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration = {
    import InputStartingPositionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration
      .builder()
      .optionallyWith(inputStartingPosition.map(value => value.unwrap))(
        _.inputStartingPosition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly =
    zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
      .wrap(buildAwsValue())
}
object InputStartingPositionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration =
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration(
        inputStartingPosition.map(value => value)
      )
    def inputStartingPosition
        : Optional[zio.aws.kinesisanalytics.model.InputStartingPosition]
    def getInputStartingPosition: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputStartingPosition
    ] =
      AwsError.unwrapOptionField("inputStartingPosition", inputStartingPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration
  ) extends zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly {
    override val inputStartingPosition
        : Optional[zio.aws.kinesisanalytics.model.InputStartingPosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputStartingPosition())
        .map(value =>
          zio.aws.kinesisanalytics.model.InputStartingPosition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration
  ): zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly =
    new Wrapper(impl)
}
