package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, FileKey, BucketARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ReferenceDataSourceUpdate(
    bucketARNUpdate: Optional[BucketARN] = Optional.Absent,
    fileKeyUpdate: Optional[FileKey] = Optional.Absent,
    referenceRoleARNUpdate: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate = {
    import S3ReferenceDataSourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
      .builder()
      .optionallyWith(
        bucketARNUpdate.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARNUpdate)
      .optionallyWith(
        fileKeyUpdate.map(value => FileKey.unwrap(value): java.lang.String)
      )(_.fileKeyUpdate)
      .optionallyWith(
        referenceRoleARNUpdate.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.referenceRoleARNUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate
      .wrap(buildAwsValue())
}
object S3ReferenceDataSourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate =
      zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate(
        bucketARNUpdate.map(value => value),
        fileKeyUpdate.map(value => value),
        referenceRoleARNUpdate.map(value => value)
      )
    def bucketARNUpdate: Optional[BucketARN]
    def fileKeyUpdate: Optional[FileKey]
    def referenceRoleARNUpdate: Optional[RoleARN]
    def getBucketARNUpdate: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARNUpdate", bucketARNUpdate)
    def getFileKeyUpdate: ZIO[Any, AwsError, FileKey] =
      AwsError.unwrapOptionField("fileKeyUpdate", fileKeyUpdate)
    def getReferenceRoleARNUpdate: ZIO[Any, AwsError, RoleARN] = AwsError
      .unwrapOptionField("referenceRoleARNUpdate", referenceRoleARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
  ) extends zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly {
    override val bucketARNUpdate: Optional[BucketARN] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.BucketARN(value))
    override val fileKeyUpdate: Optional[FileKey] = zio.aws.core.internal
      .optionalFromNullable(impl.fileKeyUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.FileKey(value))
    override val referenceRoleARNUpdate: Optional[RoleARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceRoleARNUpdate())
        .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate
  ): zio.aws.kinesisanalytics.model.S3ReferenceDataSourceUpdate.ReadOnly =
    new Wrapper(impl)
}
