package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApplicationOutputRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    outputId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest = {
    import DeleteApplicationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .outputId(Id.unwrap(outputId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest =
      zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest(
        applicationName,
        currentApplicationVersionId,
        outputId
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def outputId: Id
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getOutputId: ZIO[Any, Nothing, Id] = ZIO.succeed(outputId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest
  ) extends zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val outputId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.outputId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest
  ): zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest.ReadOnly =
    new Wrapper(impl)
}
