package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.ApplicationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopApplicationRequest(applicationName: ApplicationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest = {
    import StopApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.StopApplicationRequest.ReadOnly =
    zio.aws.kinesisanalytics.model.StopApplicationRequest.wrap(buildAwsValue())
}
object StopApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.StopApplicationRequest =
      zio.aws.kinesisanalytics.model.StopApplicationRequest(applicationName)
    def applicationName: ApplicationName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest
  ) extends zio.aws.kinesisanalytics.model.StopApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest
  ): zio.aws.kinesisanalytics.model.StopApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
