package zio.aws.kinesisanalytics.model
import scala.jdk.CollectionConverters._
sealed trait RecordFormatType {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType
}
object RecordFormatType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType
  ): zio.aws.kinesisanalytics.model.RecordFormatType = value match {
    case software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalytics.model.RecordFormatType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType =
      software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.kinesisanalytics.model.RecordFormatType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType =
      software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.JSON
  }
  case object CSV extends zio.aws.kinesisanalytics.model.RecordFormatType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType =
      software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.CSV
  }
}
