package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.ApplicationCode
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationUpdate(
    inputUpdates: Optional[
      Iterable[zio.aws.kinesisanalytics.model.InputUpdate]
    ] = Optional.Absent,
    applicationCodeUpdate: Optional[ApplicationCode] = Optional.Absent,
    outputUpdates: Optional[
      Iterable[zio.aws.kinesisanalytics.model.OutputUpdate]
    ] = Optional.Absent,
    referenceDataSourceUpdates: Optional[
      Iterable[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate]
    ] = Optional.Absent,
    cloudWatchLoggingOptionUpdates: Optional[
      Iterable[zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate = {
    import ApplicationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
      .builder()
      .optionallyWith(
        inputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputUpdates)
      .optionallyWith(
        applicationCodeUpdate.map(value =>
          ApplicationCode.unwrap(value): java.lang.String
        )
      )(_.applicationCodeUpdate)
      .optionallyWith(
        outputUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputUpdates)
      .optionallyWith(
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceUpdates)
      .optionallyWith(
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionUpdates)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.ApplicationUpdate.wrap(buildAwsValue())
}
object ApplicationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ApplicationUpdate =
      zio.aws.kinesisanalytics.model.ApplicationUpdate(
        inputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationCodeUpdate.map(value => value),
        outputUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputUpdates
        : Optional[List[zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly]]
    def applicationCodeUpdate: Optional[ApplicationCode]
    def outputUpdates
        : Optional[List[zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly]]
    def referenceDataSourceUpdates: Optional[
      List[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly]
    ]
    def cloudWatchLoggingOptionUpdates: Optional[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]]
    def getInputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("inputUpdates", inputUpdates)
    def getApplicationCodeUpdate: ZIO[Any, AwsError, ApplicationCode] =
      AwsError.unwrapOptionField("applicationCodeUpdate", applicationCodeUpdate)
    def getOutputUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("outputUpdates", outputUpdates)
    def getReferenceDataSourceUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceUpdates",
      referenceDataSourceUpdates
    )
    def getCloudWatchLoggingOptionUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionUpdates",
      cloudWatchLoggingOptionUpdates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
  ) extends zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly {
    override val inputUpdates
        : Optional[List[zio.aws.kinesisanalytics.model.InputUpdate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalytics.model.InputUpdate.wrap(item)
          }.toList
        )
    override val applicationCodeUpdate: Optional[ApplicationCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationCodeUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.ApplicationCode(value)
        )
    override val outputUpdates
        : Optional[List[zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputUpdates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalytics.model.OutputUpdate.wrap(item)
          }.toList
        )
    override val referenceDataSourceUpdates: Optional[
      List[zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceDataSourceUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.ReferenceDataSourceUpdate.wrap(item)
        }.toList
      )
    override val cloudWatchLoggingOptionUpdates: Optional[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionUpdate
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate
  ): zio.aws.kinesisanalytics.model.ApplicationUpdate.ReadOnly = new Wrapper(
    impl
  )
}
