package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InputConfiguration(
    id: Id,
    inputStartingPositionConfiguration: zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration = {
    import InputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .inputStartingPositionConfiguration(
        inputStartingPositionConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.InputConfiguration.ReadOnly =
    zio.aws.kinesisanalytics.model.InputConfiguration.wrap(buildAwsValue())
}
object InputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputConfiguration =
      zio.aws.kinesisanalytics.model
        .InputConfiguration(id, inputStartingPositionConfiguration.asEditable)
    def id: Id
    def inputStartingPositionConfiguration
        : zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly
    ] = ZIO.succeed(inputStartingPositionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration
  ) extends zio.aws.kinesisanalytics.model.InputConfiguration.ReadOnly {
    override val id: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.id())
    override val inputStartingPositionConfiguration
        : zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration.ReadOnly =
      zio.aws.kinesisanalytics.model.InputStartingPositionConfiguration
        .wrap(impl.inputStartingPositionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration
  ): zio.aws.kinesisanalytics.model.InputConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
