package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.RecordEncoding
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceSchema(
    recordFormat: zio.aws.kinesisanalytics.model.RecordFormat,
    recordEncoding: Optional[RecordEncoding] = Optional.Absent,
    recordColumns: Iterable[zio.aws.kinesisanalytics.model.RecordColumn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema = {
    import SourceSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema
      .builder()
      .recordFormat(recordFormat.buildAwsValue())
      .optionallyWith(
        recordEncoding.map(value =>
          RecordEncoding.unwrap(value): java.lang.String
        )
      )(_.recordEncoding)
      .recordColumns(recordColumns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly =
    zio.aws.kinesisanalytics.model.SourceSchema.wrap(buildAwsValue())
}
object SourceSchema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.SourceSchema =
      zio.aws.kinesisanalytics.model.SourceSchema(
        recordFormat.asEditable,
        recordEncoding.map(value => value),
        recordColumns.map { item =>
          item.asEditable
        }
      )
    def recordFormat: zio.aws.kinesisanalytics.model.RecordFormat.ReadOnly
    def recordEncoding: Optional[RecordEncoding]
    def recordColumns
        : List[zio.aws.kinesisanalytics.model.RecordColumn.ReadOnly]
    def getRecordFormat: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.RecordFormat.ReadOnly
    ] = ZIO.succeed(recordFormat)
    def getRecordEncoding: ZIO[Any, AwsError, RecordEncoding] =
      AwsError.unwrapOptionField("recordEncoding", recordEncoding)
    def getRecordColumns: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalytics.model.RecordColumn.ReadOnly
    ]] = ZIO.succeed(recordColumns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema
  ) extends zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly {
    override val recordFormat
        : zio.aws.kinesisanalytics.model.RecordFormat.ReadOnly =
      zio.aws.kinesisanalytics.model.RecordFormat.wrap(impl.recordFormat())
    override val recordEncoding: Optional[RecordEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordEncoding())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.RecordEncoding(value)
        )
    override val recordColumns
        : List[zio.aws.kinesisanalytics.model.RecordColumn.ReadOnly] = impl
      .recordColumns()
      .asScala
      .map { item =>
        zio.aws.kinesisanalytics.model.RecordColumn.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema
  ): zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly = new Wrapper(impl)
}
