package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppStreamName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputDescription(
    outputId: Optional[Id] = Optional.Absent,
    name: Optional[InAppStreamName] = Optional.Absent,
    kinesisStreamsOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription
    ] = Optional.Absent,
    kinesisFirehoseOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription
    ] = Optional.Absent,
    lambdaOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.LambdaOutputDescription
    ] = Optional.Absent,
    destinationSchema: Optional[
      zio.aws.kinesisanalytics.model.DestinationSchema
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription = {
    import OutputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
      .builder()
      .optionallyWith(
        outputId.map(value => Id.unwrap(value): java.lang.String)
      )(_.outputId)
      .optionallyWith(
        name.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        kinesisStreamsOutputDescription.map(value => value.buildAwsValue())
      )(_.kinesisStreamsOutputDescription)
      .optionallyWith(
        kinesisFirehoseOutputDescription.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseOutputDescription)
      .optionallyWith(
        lambdaOutputDescription.map(value => value.buildAwsValue())
      )(_.lambdaOutputDescription)
      .optionallyWith(destinationSchema.map(value => value.buildAwsValue()))(
        _.destinationSchema
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.OutputDescription.wrap(buildAwsValue())
}
object OutputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.OutputDescription =
      zio.aws.kinesisanalytics.model.OutputDescription(
        outputId.map(value => value),
        name.map(value => value),
        kinesisStreamsOutputDescription.map(value => value.asEditable),
        kinesisFirehoseOutputDescription.map(value => value.asEditable),
        lambdaOutputDescription.map(value => value.asEditable),
        destinationSchema.map(value => value.asEditable)
      )
    def outputId: Optional[Id]
    def name: Optional[InAppStreamName]
    def kinesisStreamsOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription.ReadOnly
    ]
    def kinesisFirehoseOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly
    ]
    def lambdaOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly
    ]
    def destinationSchema
        : Optional[zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly]
    def getOutputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("outputId", outputId)
    def getName: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("name", name)
    def getKinesisStreamsOutputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsOutputDescription",
      kinesisStreamsOutputDescription
    )
    def getKinesisFirehoseOutputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseOutputDescription",
      kinesisFirehoseOutputDescription
    )
    def getLambdaOutputDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaOutputDescription",
      lambdaOutputDescription
    )
    def getDestinationSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly
    ] = AwsError.unwrapOptionField("destinationSchema", destinationSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
  ) extends zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly {
    override val outputId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.outputId())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Id(value))
    override val name: Optional[InAppStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InAppStreamName(value)
      )
    override val kinesisStreamsOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamsOutputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsOutputDescription
          .wrap(value)
      )
    override val kinesisFirehoseOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseOutputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseOutputDescription
          .wrap(value)
      )
    override val lambdaOutputDescription: Optional[
      zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaOutputDescription())
      .map(value =>
        zio.aws.kinesisanalytics.model.LambdaOutputDescription.wrap(value)
      )
    override val destinationSchema
        : Optional[zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationSchema())
        .map(value =>
          zio.aws.kinesisanalytics.model.DestinationSchema.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription
  ): zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly = new Wrapper(
    impl
  )
}
