package zio.aws.kinesisanalytics.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisanalytics.model.primitives.{
  ApplicationCode,
  ApplicationName,
  Timestamp,
  ApplicationVersionId,
  ResourceARN,
  ApplicationDescription
}
import scala.jdk.CollectionConverters._
final case class ApplicationDetail(
    applicationName: ApplicationName,
    applicationDescription: Optional[ApplicationDescription] = Optional.Absent,
    applicationARN: ResourceARN,
    applicationStatus: zio.aws.kinesisanalytics.model.ApplicationStatus,
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdateTimestamp: Optional[Timestamp] = Optional.Absent,
    inputDescriptions: Optional[
      Iterable[zio.aws.kinesisanalytics.model.InputDescription]
    ] = Optional.Absent,
    outputDescriptions: Optional[
      Iterable[zio.aws.kinesisanalytics.model.OutputDescription]
    ] = Optional.Absent,
    referenceDataSourceDescriptions: Optional[
      Iterable[zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription]
    ] = Optional.Absent,
    cloudWatchLoggingOptionDescriptions: Optional[Iterable[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription
    ]] = Optional.Absent,
    applicationCode: Optional[ApplicationCode] = Optional.Absent,
    applicationVersionId: ApplicationVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail = {
    import ApplicationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        applicationDescription.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .applicationARN(ResourceARN.unwrap(applicationARN): java.lang.String)
      .applicationStatus(applicationStatus.unwrap)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(
        inputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDescriptions)
      .optionallyWith(
        outputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputDescriptions)
      .optionallyWith(
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceDescriptions)
      .optionallyWith(
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionDescriptions)
      .optionallyWith(
        applicationCode.map(value =>
          ApplicationCode.unwrap(value): java.lang.String
        )
      )(_.applicationCode)
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly =
    zio.aws.kinesisanalytics.model.ApplicationDetail.wrap(buildAwsValue())
}
object ApplicationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.ApplicationDetail =
      zio.aws.kinesisanalytics.model.ApplicationDetail(
        applicationName,
        applicationDescription.map(value => value),
        applicationARN,
        applicationStatus,
        createTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        inputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationCode.map(value => value),
        applicationVersionId
      )
    def applicationName: ApplicationName
    def applicationDescription: Optional[ApplicationDescription]
    def applicationARN: ResourceARN
    def applicationStatus: zio.aws.kinesisanalytics.model.ApplicationStatus
    def createTimestamp: Optional[Timestamp]
    def lastUpdateTimestamp: Optional[Timestamp]
    def inputDescriptions: Optional[
      List[zio.aws.kinesisanalytics.model.InputDescription.ReadOnly]
    ]
    def outputDescriptions: Optional[
      List[zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly]
    ]
    def referenceDataSourceDescriptions: Optional[List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly
    ]]
    def cloudWatchLoggingOptionDescriptions: Optional[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]]
    def applicationCode: Optional[ApplicationCode]
    def applicationVersionId: ApplicationVersionId
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField(
        "applicationDescription",
        applicationDescription
      )
    def getApplicationARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(applicationARN)
    def getApplicationStatus
        : ZIO[Any, Nothing, zio.aws.kinesisanalytics.model.ApplicationStatus] =
      ZIO.succeed(applicationStatus)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getInputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.InputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDescriptions", inputDescriptions)
    def getOutputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("outputDescriptions", outputDescriptions)
    def getReferenceDataSourceDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceDescriptions",
      referenceDataSourceDescriptions
    )
    def getCloudWatchLoggingOptionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionDescriptions",
      cloudWatchLoggingOptionDescriptions
    )
    def getApplicationCode: ZIO[Any, AwsError, ApplicationCode] =
      AwsError.unwrapOptionField("applicationCode", applicationCode)
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
  ) extends zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationDescription: Optional[ApplicationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationDescription())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives
            .ApplicationDescription(value)
        )
    override val applicationARN: ResourceARN =
      zio.aws.kinesisanalytics.model.primitives
        .ResourceARN(impl.applicationARN())
    override val applicationStatus
        : zio.aws.kinesisanalytics.model.ApplicationStatus =
      zio.aws.kinesisanalytics.model.ApplicationStatus
        .wrap(impl.applicationStatus())
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value => zio.aws.kinesisanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTimestamp())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.Timestamp(value)
        )
    override val inputDescriptions: Optional[
      List[zio.aws.kinesisanalytics.model.InputDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.InputDescription.wrap(item)
        }.toList
      )
    override val outputDescriptions: Optional[
      List[zio.aws.kinesisanalytics.model.OutputDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.OutputDescription.wrap(item)
        }.toList
      )
    override val referenceDataSourceDescriptions: Optional[List[
      zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceDataSourceDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.ReferenceDataSourceDescription
            .wrap(item)
        }.toList
      )
    override val cloudWatchLoggingOptionDescriptions: Optional[List[
      zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalytics.model.CloudWatchLoggingOptionDescription
            .wrap(item)
        }.toList
      )
    override val applicationCode: Optional[ApplicationCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationCode())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.ApplicationCode(value)
        )
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalytics.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail
  ): zio.aws.kinesisanalytics.model.ApplicationDetail.ReadOnly = new Wrapper(
    impl
  )
}
