package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{InAppStreamName, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputUpdate(
    outputId: Id,
    nameUpdate: Optional[InAppStreamName] = Optional.Absent,
    kinesisStreamsOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate
    ] = Optional.Absent,
    kinesisFirehoseOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputUpdate
    ] = Optional.Absent,
    lambdaOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.LambdaOutputUpdate
    ] = Optional.Absent,
    destinationSchemaUpdate: Optional[
      zio.aws.kinesisanalytics.model.DestinationSchema
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate = {
    import OutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate
      .builder()
      .outputId(Id.unwrap(outputId): java.lang.String)
      .optionallyWith(
        nameUpdate.map(value => InAppStreamName.unwrap(value): java.lang.String)
      )(_.nameUpdate)
      .optionallyWith(
        kinesisStreamsOutputUpdate.map(value => value.buildAwsValue())
      )(_.kinesisStreamsOutputUpdate)
      .optionallyWith(
        kinesisFirehoseOutputUpdate.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseOutputUpdate)
      .optionallyWith(lambdaOutputUpdate.map(value => value.buildAwsValue()))(
        _.lambdaOutputUpdate
      )
      .optionallyWith(
        destinationSchemaUpdate.map(value => value.buildAwsValue())
      )(_.destinationSchemaUpdate)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.OutputUpdate.wrap(buildAwsValue())
}
object OutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.OutputUpdate =
      zio.aws.kinesisanalytics.model.OutputUpdate(
        outputId,
        nameUpdate.map(value => value),
        kinesisStreamsOutputUpdate.map(value => value.asEditable),
        kinesisFirehoseOutputUpdate.map(value => value.asEditable),
        lambdaOutputUpdate.map(value => value.asEditable),
        destinationSchemaUpdate.map(value => value.asEditable)
      )
    def outputId: Id
    def nameUpdate: Optional[InAppStreamName]
    def kinesisStreamsOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.ReadOnly
    ]
    def kinesisFirehoseOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputUpdate.ReadOnly
    ]
    def lambdaOutputUpdate
        : Optional[zio.aws.kinesisanalytics.model.LambdaOutputUpdate.ReadOnly]
    def destinationSchemaUpdate
        : Optional[zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly]
    def getOutputId: ZIO[Any, Nothing, Id] = ZIO.succeed(outputId)
    def getNameUpdate: ZIO[Any, AwsError, InAppStreamName] =
      AwsError.unwrapOptionField("nameUpdate", nameUpdate)
    def getKinesisStreamsOutputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisStreamsOutputUpdate",
      kinesisStreamsOutputUpdate
    )
    def getKinesisFirehoseOutputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseOutputUpdate",
      kinesisFirehoseOutputUpdate
    )
    def getLambdaOutputUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.LambdaOutputUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaOutputUpdate", lambdaOutputUpdate)
    def getDestinationSchemaUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationSchemaUpdate",
      destinationSchemaUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate
  ) extends zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly {
    override val outputId: Id =
      zio.aws.kinesisanalytics.model.primitives.Id(impl.outputId())
    override val nameUpdate: Optional[InAppStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InAppStreamName(value)
      )
    override val kinesisStreamsOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamsOutputUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsOutputUpdate.wrap(value)
      )
    override val kinesisFirehoseOutputUpdate: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseOutputUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseOutputUpdate())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseOutputUpdate.wrap(value)
      )
    override val lambdaOutputUpdate
        : Optional[zio.aws.kinesisanalytics.model.LambdaOutputUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaOutputUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.LambdaOutputUpdate.wrap(value)
        )
    override val destinationSchemaUpdate
        : Optional[zio.aws.kinesisanalytics.model.DestinationSchema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationSchemaUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.DestinationSchema.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate
  ): zio.aws.kinesisanalytics.model.OutputUpdate.ReadOnly = new Wrapper(impl)
}
