package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputLambdaProcessorUpdate(
    resourceARNUpdate: Optional[ResourceARN] = Optional.Absent,
    roleARNUpdate: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate = {
    import InputLambdaProcessorUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate
      .builder()
      .optionallyWith(
        resourceARNUpdate.map(value =>
          ResourceARN.unwrap(value): java.lang.String
        )
      )(_.resourceARNUpdate)
      .optionallyWith(
        roleARNUpdate.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARNUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.InputLambdaProcessorUpdate.ReadOnly =
    zio.aws.kinesisanalytics.model.InputLambdaProcessorUpdate
      .wrap(buildAwsValue())
}
object InputLambdaProcessorUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputLambdaProcessorUpdate =
      zio.aws.kinesisanalytics.model.InputLambdaProcessorUpdate(
        resourceARNUpdate.map(value => value),
        roleARNUpdate.map(value => value)
      )
    def resourceARNUpdate: Optional[ResourceARN]
    def roleARNUpdate: Optional[RoleARN]
    def getResourceARNUpdate: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARNUpdate", resourceARNUpdate)
    def getRoleARNUpdate: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate
  ) extends zio.aws.kinesisanalytics.model.InputLambdaProcessorUpdate.ReadOnly {
    override val resourceARNUpdate: Optional[ResourceARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceARNUpdate())
        .map(value =>
          zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
        )
    override val roleARNUpdate: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARNUpdate())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate
  ): zio.aws.kinesisanalytics.model.InputLambdaProcessorUpdate.ReadOnly =
    new Wrapper(impl)
}
