package zio.aws.kinesisanalytics
import zio.aws.core.config.AwsConfig
import zio.aws.kinesisanalytics.model.TagResourceResponse.ReadOnly
import software.amazon.awssdk.services.kinesisanalytics.{
  KinesisAnalyticsAsyncClientBuilder,
  KinesisAnalyticsAsyncClient
}
import software.amazon.awssdk.services.kinesisanalytics.model.{
  UpdateApplicationRequest,
  DeleteApplicationCloudWatchLoggingOptionRequest,
  DeleteApplicationOutputResponse,
  DeleteApplicationRequest,
  AddApplicationReferenceDataSourceResponse,
  AddApplicationOutputRequest,
  StartApplicationRequest,
  AddApplicationReferenceDataSourceRequest,
  DeleteApplicationInputProcessingConfigurationResponse,
  DescribeApplicationResponse,
  UpdateApplicationResponse,
  AddApplicationCloudWatchLoggingOptionRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  StartApplicationResponse,
  DiscoverInputSchemaRequest,
  AddApplicationCloudWatchLoggingOptionResponse,
  DeleteApplicationInputProcessingConfigurationRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeApplicationRequest,
  ListApplicationsResponse,
  AddApplicationInputProcessingConfigurationResponse,
  DeleteApplicationCloudWatchLoggingOptionResponse,
  CreateApplicationResponse,
  AddApplicationInputResponse,
  StopApplicationResponse,
  UntagResourceRequest,
  DeleteApplicationReferenceDataSourceResponse,
  DiscoverInputSchemaResponse,
  ListApplicationsRequest,
  AddApplicationInputProcessingConfigurationRequest,
  StopApplicationRequest,
  DeleteApplicationReferenceDataSourceRequest,
  DeleteApplicationOutputRequest,
  TagResourceResponse,
  AddApplicationOutputResponse,
  DeleteApplicationResponse,
  TagResourceRequest,
  AddApplicationInputRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters._
trait KinesisAnalytics extends AspectSupport[KinesisAnalytics] {
  val api: KinesisAnalyticsAsyncClient
  def deleteApplication(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationResponse.ReadOnly
  ]
  def addApplicationReferenceDataSource(
      request: zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse.ReadOnly
  ]
  def describeApplication(
      request: zio.aws.kinesisanalytics.model.DescribeApplicationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly
  ]
  def deleteApplicationOutput(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationOutputResponse.ReadOnly
  ]
  def createApplication(
      request: zio.aws.kinesisanalytics.model.CreateApplicationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly
  ]
  def discoverInputSchema(
      request: zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly
  ]
  def deleteApplicationInputProcessingConfiguration(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
  ]
  def addApplicationCloudWatchLoggingOption(
      request: zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ]
  def addApplicationOutput(
      request: zio.aws.kinesisanalytics.model.AddApplicationOutputRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationOutputResponse.ReadOnly
  ]
  def startApplication(
      request: zio.aws.kinesisanalytics.model.StartApplicationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.StartApplicationResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.kinesisanalytics.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.kinesisanalytics.model.UntagResourceResponse.ReadOnly]
  def deleteApplicationCloudWatchLoggingOption(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ]
  def addApplicationInputProcessingConfiguration(
      request: zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.kinesisanalytics.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.ListTagsForResourceResponse.ReadOnly
  ]
  def addApplicationInput(
      request: zio.aws.kinesisanalytics.model.AddApplicationInputRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationInputResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.kinesisanalytics.model.TagResourceRequest
  ): IO[AwsError, ReadOnly]
  def listApplications(
      request: zio.aws.kinesisanalytics.model.ListApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly
  ]
  def updateApplication(
      request: zio.aws.kinesisanalytics.model.UpdateApplicationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.UpdateApplicationResponse.ReadOnly
  ]
  def deleteApplicationReferenceDataSource(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
  ]
  def stopApplication(
      request: zio.aws.kinesisanalytics.model.StopApplicationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalytics.model.StopApplicationResponse.ReadOnly
  ]
}
object KinesisAnalytics {
  val live: ZLayer[AwsConfig, java.lang.Throwable, KinesisAnalytics] =
    customized(identity)
  def customized(
      customization: KinesisAnalyticsAsyncClientBuilder => KinesisAnalyticsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, KinesisAnalytics] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KinesisAnalyticsAsyncClientBuilder => KinesisAnalyticsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, KinesisAnalytics] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = KinesisAnalyticsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      KinesisAnalyticsAsyncClient,
      KinesisAnalyticsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      KinesisAnalyticsAsyncClient,
      KinesisAnalyticsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new KinesisAnalyticsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class KinesisAnalyticsImpl[R](
      override val api: KinesisAnalyticsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends KinesisAnalytics
      with AwsServiceBase[R] {
    override val serviceName: String = "KinesisAnalytics"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KinesisAnalyticsImpl[R1] = new KinesisAnalyticsImpl(api, newAspect, r)
    def deleteApplication(
        request: zio.aws.kinesisanalytics.model.DeleteApplicationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DeleteApplicationResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteApplicationRequest, DeleteApplicationResponse](
        "deleteApplication",
        api.deleteApplication
      )(request.buildAwsValue())
        .map(zio.aws.kinesisanalytics.model.DeleteApplicationResponse.wrap)
        .provideEnvironment(r)
    def addApplicationReferenceDataSource(
        request: zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      AddApplicationReferenceDataSourceRequest,
      AddApplicationReferenceDataSourceResponse
    ](
      "addApplicationReferenceDataSource",
      api.addApplicationReferenceDataSource
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse.wrap
      )
      .provideEnvironment(r)
    def describeApplication(
        request: zio.aws.kinesisanalytics.model.DescribeApplicationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeApplicationRequest,
      DescribeApplicationResponse
    ]("describeApplication", api.describeApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.DescribeApplicationResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationOutput(
        request: zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DeleteApplicationOutputResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApplicationOutputRequest,
      DeleteApplicationOutputResponse
    ]("deleteApplicationOutput", api.deleteApplicationOutput)(
      request.buildAwsValue()
    ).map(zio.aws.kinesisanalytics.model.DeleteApplicationOutputResponse.wrap)
      .provideEnvironment(r)
    def createApplication(
        request: zio.aws.kinesisanalytics.model.CreateApplicationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateApplicationRequest, CreateApplicationResponse](
        "createApplication",
        api.createApplication
      )(request.buildAwsValue())
        .map(zio.aws.kinesisanalytics.model.CreateApplicationResponse.wrap)
        .provideEnvironment(r)
    def discoverInputSchema(
        request: zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      DiscoverInputSchemaRequest,
      DiscoverInputSchemaResponse
    ]("discoverInputSchema", api.discoverInputSchema)(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationInputProcessingConfiguration(
        request: zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApplicationInputProcessingConfigurationRequest,
      DeleteApplicationInputProcessingConfigurationResponse
    ](
      "deleteApplicationInputProcessingConfiguration",
      api.deleteApplicationInputProcessingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def addApplicationCloudWatchLoggingOption(
        request: zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      AddApplicationCloudWatchLoggingOptionRequest,
      AddApplicationCloudWatchLoggingOptionResponse
    ](
      "addApplicationCloudWatchLoggingOption",
      api.addApplicationCloudWatchLoggingOption
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse.wrap
      )
      .provideEnvironment(r)
    def addApplicationOutput(
        request: zio.aws.kinesisanalytics.model.AddApplicationOutputRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.AddApplicationOutputResponse.ReadOnly
    ] = asyncRequestResponse[
      AddApplicationOutputRequest,
      AddApplicationOutputResponse
    ]("addApplicationOutput", api.addApplicationOutput)(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.AddApplicationOutputResponse.wrap)
      .provideEnvironment(r)
    def startApplication(
        request: zio.aws.kinesisanalytics.model.StartApplicationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.StartApplicationResponse.ReadOnly
    ] = asyncRequestResponse[StartApplicationRequest, StartApplicationResponse](
      "startApplication",
      api.startApplication
    )(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.StartApplicationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.kinesisanalytics.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationCloudWatchLoggingOption(
        request: zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApplicationCloudWatchLoggingOptionRequest,
      DeleteApplicationCloudWatchLoggingOptionResponse
    ](
      "deleteApplicationCloudWatchLoggingOption",
      api.deleteApplicationCloudWatchLoggingOption
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse.wrap
      )
      .provideEnvironment(r)
    def addApplicationInputProcessingConfiguration(
        request: zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      AddApplicationInputProcessingConfigurationRequest,
      AddApplicationInputProcessingConfigurationResponse
    ](
      "addApplicationInputProcessingConfiguration",
      api.addApplicationInputProcessingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.kinesisanalytics.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def addApplicationInput(
        request: zio.aws.kinesisanalytics.model.AddApplicationInputRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.AddApplicationInputResponse.ReadOnly
    ] = asyncRequestResponse[
      AddApplicationInputRequest,
      AddApplicationInputResponse
    ]("addApplicationInput", api.addApplicationInput)(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.AddApplicationInputResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.kinesisanalytics.model.TagResourceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.kinesisanalytics.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listApplications(
        request: zio.aws.kinesisanalytics.model.ListApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[ListApplicationsRequest, ListApplicationsResponse](
      "listApplications",
      api.listApplications
    )(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(
        request: zio.aws.kinesisanalytics.model.UpdateApplicationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.UpdateApplicationResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateApplicationRequest, UpdateApplicationResponse](
        "updateApplication",
        api.updateApplication
      )(request.buildAwsValue())
        .map(zio.aws.kinesisanalytics.model.UpdateApplicationResponse.wrap)
        .provideEnvironment(r)
    def deleteApplicationReferenceDataSource(
        request: zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApplicationReferenceDataSourceRequest,
      DeleteApplicationReferenceDataSourceResponse
    ](
      "deleteApplicationReferenceDataSource",
      api.deleteApplicationReferenceDataSource
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse.wrap
      )
      .provideEnvironment(r)
    def stopApplication(
        request: zio.aws.kinesisanalytics.model.StopApplicationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalytics.model.StopApplicationResponse.ReadOnly
    ] = asyncRequestResponse[StopApplicationRequest, StopApplicationResponse](
      "stopApplication",
      api.stopApplication
    )(request.buildAwsValue())
      .map(zio.aws.kinesisanalytics.model.StopApplicationResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteApplication(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def addApplicationReferenceDataSource(
      request: zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationReferenceDataSource(request))
  def describeApplication(
      request: zio.aws.kinesisanalytics.model.DescribeApplicationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DescribeApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplication(request))
  def deleteApplicationOutput(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationOutputRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationOutput(request))
  def createApplication(
      request: zio.aws.kinesisanalytics.model.CreateApplicationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def discoverInputSchema(
      request: zio.aws.kinesisanalytics.model.DiscoverInputSchemaRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DiscoverInputSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.discoverInputSchema(request))
  def deleteApplicationInputProcessingConfiguration(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deleteApplicationInputProcessingConfiguration(request))
  def addApplicationCloudWatchLoggingOption(
      request: zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationCloudWatchLoggingOption(request))
  def addApplicationOutput(
      request: zio.aws.kinesisanalytics.model.AddApplicationOutputRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationOutput(request))
  def startApplication(
      request: zio.aws.kinesisanalytics.model.StartApplicationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.StartApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startApplication(request))
  def untagResource(
      request: zio.aws.kinesisanalytics.model.UntagResourceRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteApplicationCloudWatchLoggingOption(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationCloudWatchLoggingOption(request))
  def addApplicationInputProcessingConfiguration(
      request: zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationInputProcessingConfiguration(request))
  def listTagsForResource(
      request: zio.aws.kinesisanalytics.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def addApplicationInput(
      request: zio.aws.kinesisanalytics.model.AddApplicationInputRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.AddApplicationInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationInput(request))
  def tagResource(
      request: zio.aws.kinesisanalytics.model.TagResourceRequest
  ): ZIO[zio.aws.kinesisanalytics.KinesisAnalytics, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(
      request: zio.aws.kinesisanalytics.model.ListApplicationsRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplications(request))
  def updateApplication(
      request: zio.aws.kinesisanalytics.model.UpdateApplicationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def deleteApplicationReferenceDataSource(
      request: zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationReferenceDataSource(request))
  def stopApplication(
      request: zio.aws.kinesisanalytics.model.StopApplicationRequest
  ): ZIO[
    zio.aws.kinesisanalytics.KinesisAnalytics,
    AwsError,
    zio.aws.kinesisanalytics.model.StopApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopApplication(request))
}
