package zio.aws.kinesisanalytics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisanalytics.model.primitives.InputParallelismCount
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InputParallelism(
    count: Optional[InputParallelismCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism = {
    import InputParallelism.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism
      .builder()
      .optionallyWith(
        count.map(value => InputParallelismCount.unwrap(value): Integer)
      )(_.count)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly =
    zio.aws.kinesisanalytics.model.InputParallelism.wrap(buildAwsValue())
}
object InputParallelism {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.InputParallelism =
      zio.aws.kinesisanalytics.model.InputParallelism(count.map(value => value))
    def count: Optional[InputParallelismCount]
    def getCount: ZIO[Any, AwsError, InputParallelismCount] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism
  ) extends zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly {
    override val count: Optional[InputParallelismCount] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.InputParallelismCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism
  ): zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly = new Wrapper(
    impl
  )
}
