package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.InAppStreamName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Input(
    namePrefix: InAppStreamName,
    inputProcessingConfiguration: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration
    ] = Optional.Absent,
    kinesisStreamsInput: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInput
    ] = Optional.Absent,
    kinesisFirehoseInput: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInput
    ] = Optional.Absent,
    inputParallelism: Optional[
      zio.aws.kinesisanalytics.model.InputParallelism
    ] = Optional.Absent,
    inputSchema: zio.aws.kinesisanalytics.model.SourceSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.Input = {
    import Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.Input
      .builder()
      .namePrefix(InAppStreamName.unwrap(namePrefix): java.lang.String)
      .optionallyWith(
        inputProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.inputProcessingConfiguration)
      .optionallyWith(kinesisStreamsInput.map(value => value.buildAwsValue()))(
        _.kinesisStreamsInput
      )
      .optionallyWith(kinesisFirehoseInput.map(value => value.buildAwsValue()))(
        _.kinesisFirehoseInput
      )
      .optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(
        _.inputParallelism
      )
      .inputSchema(inputSchema.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.Input.ReadOnly =
    zio.aws.kinesisanalytics.model.Input.wrap(buildAwsValue())
}
object Input {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.Input
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.Input =
      zio.aws.kinesisanalytics.model.Input(
        namePrefix,
        inputProcessingConfiguration.map(value => value.asEditable),
        kinesisStreamsInput.map(value => value.asEditable),
        kinesisFirehoseInput.map(value => value.asEditable),
        inputParallelism.map(value => value.asEditable),
        inputSchema.asEditable
      )
    def namePrefix: InAppStreamName
    def inputProcessingConfiguration: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ]
    def kinesisStreamsInput
        : Optional[zio.aws.kinesisanalytics.model.KinesisStreamsInput.ReadOnly]
    def kinesisFirehoseInput
        : Optional[zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly]
    def inputParallelism
        : Optional[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly]
    def inputSchema: zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    def getNamePrefix: ZIO[Any, Nothing, InAppStreamName] =
      ZIO.succeed(namePrefix)
    def getInputProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfiguration",
      inputProcessingConfiguration
    )
    def getKinesisStreamsInput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisStreamsInput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisStreamsInput", kinesisStreamsInput)
    def getKinesisFirehoseInput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisFirehoseInput", kinesisFirehoseInput)
    def getInputParallelism: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly
    ] = AwsError.unwrapOptionField("inputParallelism", inputParallelism)
    def getInputSchema: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly
    ] = ZIO.succeed(inputSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.Input
  ) extends zio.aws.kinesisanalytics.model.Input.ReadOnly {
    override val namePrefix: InAppStreamName =
      zio.aws.kinesisanalytics.model.primitives
        .InAppStreamName(impl.namePrefix())
    override val inputProcessingConfiguration: Optional[
      zio.aws.kinesisanalytics.model.InputProcessingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputProcessingConfiguration())
      .map(value =>
        zio.aws.kinesisanalytics.model.InputProcessingConfiguration.wrap(value)
      )
    override val kinesisStreamsInput: Optional[
      zio.aws.kinesisanalytics.model.KinesisStreamsInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamsInput())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisStreamsInput.wrap(value)
      )
    override val kinesisFirehoseInput: Optional[
      zio.aws.kinesisanalytics.model.KinesisFirehoseInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseInput())
      .map(value =>
        zio.aws.kinesisanalytics.model.KinesisFirehoseInput.wrap(value)
      )
    override val inputParallelism
        : Optional[zio.aws.kinesisanalytics.model.InputParallelism.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputParallelism())
        .map(value =>
          zio.aws.kinesisanalytics.model.InputParallelism.wrap(value)
        )
    override val inputSchema
        : zio.aws.kinesisanalytics.model.SourceSchema.ReadOnly =
      zio.aws.kinesisanalytics.model.SourceSchema.wrap(impl.inputSchema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.Input
  ): zio.aws.kinesisanalytics.model.Input.ReadOnly = new Wrapper(impl)
}
