package zio.aws.kinesisanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecordFormat(
    recordFormatType: zio.aws.kinesisanalytics.model.RecordFormatType,
    mappingParameters: Optional[
      zio.aws.kinesisanalytics.model.MappingParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat = {
    import RecordFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat
      .builder()
      .recordFormatType(recordFormatType.unwrap)
      .optionallyWith(mappingParameters.map(value => value.buildAwsValue()))(
        _.mappingParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.RecordFormat.ReadOnly =
    zio.aws.kinesisanalytics.model.RecordFormat.wrap(buildAwsValue())
}
object RecordFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.RecordFormat =
      zio.aws.kinesisanalytics.model.RecordFormat(
        recordFormatType,
        mappingParameters.map(value => value.asEditable)
      )
    def recordFormatType: zio.aws.kinesisanalytics.model.RecordFormatType
    def mappingParameters
        : Optional[zio.aws.kinesisanalytics.model.MappingParameters.ReadOnly]
    def getRecordFormatType
        : ZIO[Any, Nothing, zio.aws.kinesisanalytics.model.RecordFormatType] =
      ZIO.succeed(recordFormatType)
    def getMappingParameters: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalytics.model.MappingParameters.ReadOnly
    ] = AwsError.unwrapOptionField("mappingParameters", mappingParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat
  ) extends zio.aws.kinesisanalytics.model.RecordFormat.ReadOnly {
    override val recordFormatType
        : zio.aws.kinesisanalytics.model.RecordFormatType =
      zio.aws.kinesisanalytics.model.RecordFormatType
        .wrap(impl.recordFormatType())
    override val mappingParameters
        : Optional[zio.aws.kinesisanalytics.model.MappingParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mappingParameters())
        .map(value =>
          zio.aws.kinesisanalytics.model.MappingParameters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat
  ): zio.aws.kinesisanalytics.model.RecordFormat.ReadOnly = new Wrapper(impl)
}
