package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{RoleARN, ResourceARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaOutputDescription(
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputDescription = {
    import LambdaOutputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputDescription
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly =
    zio.aws.kinesisanalytics.model.LambdaOutputDescription.wrap(buildAwsValue())
}
object LambdaOutputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.LambdaOutputDescription =
      zio.aws.kinesisanalytics.model.LambdaOutputDescription(
        resourceARN.map(value => value),
        roleARN.map(value => value)
      )
    def resourceARN: Optional[ResourceARN]
    def roleARN: Optional[RoleARN]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputDescription
  ) extends zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly {
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value =>
        zio.aws.kinesisanalytics.model.primitives.ResourceARN(value)
      )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.kinesisanalytics.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutputDescription
  ): zio.aws.kinesisanalytics.model.LambdaOutputDescription.ReadOnly =
    new Wrapper(impl)
}
