package zio.aws.kinesisanalytics.model
import zio.aws.kinesisanalytics.model.primitives.{
  RecordColumnDelimiter,
  RecordRowDelimiter
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CSVMappingParameters(
    recordRowDelimiter: RecordRowDelimiter,
    recordColumnDelimiter: RecordColumnDelimiter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters = {
    import CSVMappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters
      .builder()
      .recordRowDelimiter(
        RecordRowDelimiter.unwrap(recordRowDelimiter): java.lang.String
      )
      .recordColumnDelimiter(
        RecordColumnDelimiter.unwrap(recordColumnDelimiter): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalytics.model.CSVMappingParameters.ReadOnly =
    zio.aws.kinesisanalytics.model.CSVMappingParameters.wrap(buildAwsValue())
}
object CSVMappingParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalytics.model.CSVMappingParameters =
      zio.aws.kinesisanalytics.model
        .CSVMappingParameters(recordRowDelimiter, recordColumnDelimiter)
    def recordRowDelimiter: RecordRowDelimiter
    def recordColumnDelimiter: RecordColumnDelimiter
    def getRecordRowDelimiter: ZIO[Any, Nothing, RecordRowDelimiter] =
      ZIO.succeed(recordRowDelimiter)
    def getRecordColumnDelimiter: ZIO[Any, Nothing, RecordColumnDelimiter] =
      ZIO.succeed(recordColumnDelimiter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters
  ) extends zio.aws.kinesisanalytics.model.CSVMappingParameters.ReadOnly {
    override val recordRowDelimiter: RecordRowDelimiter =
      zio.aws.kinesisanalytics.model.primitives
        .RecordRowDelimiter(impl.recordRowDelimiter())
    override val recordColumnDelimiter: RecordColumnDelimiter =
      zio.aws.kinesisanalytics.model.primitives
        .RecordColumnDelimiter(impl.recordColumnDelimiter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters
  ): zio.aws.kinesisanalytics.model.CSVMappingParameters.ReadOnly = new Wrapper(
    impl
  )
}
